require "API/DST_API"
require "API/DST_Helpers"

local DST = rawget(_G, "DST") or {}
local ST  = DST and DST.SkillTooltips
if not ST then return end

local KEY = "Electrical"

ST.addContributor(KEY, function(ctx)
    local lvl = ctx.getLevel()

    ctx.addHeader(ST.getText("IGUI_DST_Core_hdr"))
    
    -- Generator repair effectiveness per Electrical level
    -- L1–2=4%, L3=5%, L4–5=6%, L6–7=7%, L8–9=8%, L10=9%
    local pct = math.min(9, 3 + math.ceil(lvl / 2))
    ctx.add(ST.getText("IGUI_DST_Electrical_val_GenRepair", tostring(pct)))

    -- Operate / connect / repair availability
    if lvl > 2 then
        -- At ≥3 Electrical: native ability
        ctx.add(ST.getText("IGUI_DST_Electrical_val_HowToUseGen"))
    else
        -- Optional: show unlock hint when below 3
        ctx.add(ST.getText("IGUI_DST_Electrical_hint_GenMagOrOcc"))
    end
end)

ST.addAutoLearnRecipes(KEY)
ST.addUnlockCraftRecipes(KEY)
ST.addUnlockBuildRecipes(KEY)